﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DataPackages.aspx.cs" Inherits="ccPublisherWeb.DataPackages" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title></title>

   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ErrorPanel.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="DataPackages.css" runat="server" />
</head>
<body id="DataPackages">
   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_Main" runat="server">
         <div id="DPMain">
            <asp:PlaceHolder ID="Placeholder_PackageLocationSelector" runat="server">
               <div id="PackageLocationSelector">
                  <a href="?SOURCE=<%# PackageSources.Local.ToString() %>" onclick="tabSelected(this)" class="<%# TabPackageSourceLocalCssClassSelected %>">
                     <span class="DRight">
                        <span class="DCenter">
                           <span class="Label DVD"><%# ccPublisherWeb.TextDic.TxGet("Text_DlPackageLocation_DVD") %></span>
                        </span>
                     </span>
                  </a>
                  <a href="?SOURCE=<%# PackageSources.Online.ToString() %>" onclick="tabSelected(this)" class="Following<%# TabPackageSourceOnlineCssClassSelected %>">
                     <span class="DRight">
                        <span class="DCenter">
                           <span class="Label Online"><%# ccPublisherWeb.TextDic.TxGet("Text_DlPackageLocation_Online") %></span>
                        </span>
                     </span>
                  </a>
               </div>
            </asp:PlaceHolder><asp:PlaceHolder ID="Placeholder_SelectContainer" runat="server">
               <div id="DPSelectContainer">
                  <table border="0" cellpadding="0" cellspacing="0">
                     <thead>
                        <tr>
                           <th class="Category">
                              <div class="DLeft"><span>
                                 <%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Header_Category") %></span>
                                 <input id="CategorySearch" type="text" />
                              </div>
                           </th>
                           <th class="CadFormat"><span><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Header_CadFormatNumber")%></span></th>
                           <th class="Language">
                              <div class="DRight"><span><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Header_LanguagesNumber") %></span></div>
                           </th>
                        </tr>
                     </thead>

                     <tbody>
                        <tr class="SelectBoxes">
                           <td class="Category">
                              <div class="Container">
                                 <asp:Repeater ID="Repeater_Categories" OnItemCreated="Repeater_Categories_ItemCreated" runat="server">
                                    <ItemTemplate>
                                       <h1 groupid="<%# Eval("GroupID") %>" class="CategoryHeader"><%# Eval("PackageGroupTitle") %></h1>
                                       <ul groupid="<%# Eval("GroupID") %>" class="CategoryBox">
                                          <asp:Repeater ID="Repeater_PackageItems" runat="server">
                                             <ItemTemplate>
                                                <li><a groupid="<%# DataBinder.Eval(Container.DataItem, "GroupID") %>" class="GroupTitle" href="#"><%# DataBinder.Eval(Container.DataItem, "PackageGroupTitle") %></a></li>
                                             </ItemTemplate>
                                          </asp:Repeater>
                                       </ul>
                                    </ItemTemplate>
                                 </asp:Repeater>
                                 <span id="CategoryNoSearchResults" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_NoCategorySearchResults") %></span>
                              </div>
                           </td>

                           <td class="CadFormat">
                              <div class="Container">
                                 <ul style="display: none">
                                    <li class="All"><a href="#" cadformat=""><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Item_AllCadFormats") %></a></li>
                                    <%-- List entries are being added via AJAX callback --%>
                                 </ul>
                                 <span class="PleaseSelect MaxWidth Level1" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_Category") %></span>
                                 <span class="NoResultMessage Level1" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_NoCadFormatResults") %></span>
                                 <div class="Spinner" style="display: none"></div>
                              </div>
                           </td>

                           <td class="Language">
                              <div class="Container">
                                 <ul style="display: none">
                                    <li class="All"><a href="#" cadformat=""><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Item_AllLanguages") %></a></li>
                                    <%-- List entries are being added via AJAX callback --%>
                                 </ul>
                                 <span class="PleaseSelect MaxWidth Level1" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_Category") %></span>
                                 <span class="PleaseSelect MaxWidth Level2" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_CadFormat") %></span>
                                 <span class="NoResultMessage Level1 Level2" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_NoLanguageResults") %></span>
                                 <div class="Spinner" style="display: none"></div>
                              </div>
                           </td>
                        </tr>
                     </tbody>
                  </table>
               </div>
               <div id="DPResultContainer">
                  <div class="Header">
                     <span><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_Header_ResultPackages") %></span>
                  </div>
                  <div class="ResultList">
                     <ul>
                        <%-- List entries are being added via AJAX callback --%>
                     </ul>
                     <span class="PleaseSelect Level1" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_Category") %></span>
                     <span class="PleaseSelect Level2" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_CadFormat") %></span>
                     <span class="PleaseSelect Level3" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_PleaseSelect_Language") %></span>
                     <span class="NoResultMessage Level1 Level2 Level3" style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_NoPackageResults") %></span>
                  
                     <div class="Spinner" style="display: none"></div>
                  </div>
               </div>
            </asp:PlaceHolder>

            <asp:PlaceHolder ID="Placeholder_OnlineErrorContainer" Visible="false" runat="server">
               <div id="OnlineErrorContainer">
                  <div class="Header">
                     <span><%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_OnlineErrorHeader") %></span>
                  </div>
                  <div class="ErrorText">
                     <asp:Literal ID="lbErrorMessage" runat="server" />
                     <asp:Label ID="lbErrorDetail" Visible="false" class="ErrorDetail" runat="server" />
                  </div>
               </div>
            </asp:PlaceHolder>

            <div id="SpinnerMain" style="display: none"></div>
         </div>
         <asp:PlaceHolder ID="Placeholder_FooterNotesDVD" runat="server">
            <div id="FooterNoteText">
               <span><%# ccPublisherWeb.TextDic.TxGet("Text_DlPackageLocation_DVDNoteToOnline") %></span>
            </div>
         </asp:PlaceHolder>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Error" Visible="false" runat="server">
         <div id="ErrorDiv">
            <ccPublisherWeb:ErrorPanel ID="ErrorPanel" CssClass="ErrorPanel" runat="server" />
         </div>
      </asp:PlaceHolder>
   </form>

   <script language="javascript" type="text/javascript">
      var dataPackages = null;

      function showError(titleText, errorText) {
         <%# MessageBoxID %>.Show({
            title: titleText,
            messageText: errorText,
            width: 400,
            minHeight: 80,
            icon: MessageBox.Constants.MB_ICON_ERROR,
            buttons: MessageBox.Constants.MB_OK
         });
      }

      function tabSelected(sender) {
         $("#SpinnerMain").show();
         $("#PackageLocationSelector A").removeClass("Selected");
         $(sender).toggleClass("Selected", true);
      }


      $(function() {
         dataPackages = new DataPackages({
            baseDownloadURL: "<%# BaseDownloadUrl %>",
            userID: <%# UserID %>,
            sessionID: '<%# Session.SessionID %>',
            isOnline: <%# CommonFunc.JsBool(ccPublisherWeb.CommonSettings.ApplicationOnlineVersion) %>,
            dataPackageCheckOK: "<%# ccPublisherWeb.DataPackage.DATA_PACKAGE_CHECK_OK %>",
            packageSource: "<%# PackageSource.ToString() %>",
            packageSources: {
               Local: "<%# PackageSources.Local %>",
               Online: "<%# PackageSources.Online %>"
            },
            templates: {
               cadFormat: '<%# ccPublisherWeb.CommonFunc.FlatString(new ccPublisherWeb.TemplateHandler("~/templates/DataPackages_CadFormat.htm", TemplateSourceTypes.RelativePath).getResult()) %>',
               language: '<%# ccPublisherWeb.CommonFunc.FlatString(new ccPublisherWeb.TemplateHandler("~/templates/DataPackages_Language.htm", TemplateSourceTypes.RelativePath).getResult()) %>',
               pack: '<%# ccPublisherWeb.CommonFunc.FlatString(new ccPublisherWeb.TemplateHandler("~/templates/DataPackages_Package.htm", TemplateSourceTypes.RelativePath).getResult()) %>'
            },
            strings: {
               Text_DataPackages_DownloadError_Title: "<%# ccPublisherWeb.TextDic.TxGet("Text_DataPackages_DownloadError_Title") %>"
            }
         });
      });
   </script>
</body>
</html>
