<%@ Page Language="C#" AutoEventWireup="true" Inherits="ccPublisherWeb.Menu" Codebehind="Menu.aspx.cs" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Navigation</title>

    <ccPublisherWeb:CustomerStyleSheet StyleSheetName="Menu.css" runat="server" />

    <style type="text/css">
        .next {
            clear: both;
            height: 1px;
            width: 1px;
            overflow: hidden;
        }
    </style>

    <asp:PlaceHolder ID="Placeholder_MenuScript" runat="server">
        <script language="javascript" type="text/javascript">
            <!--
            var logPrefix = 'Menu.aspx';
            var logSeparator = ' - ';
            var logIsDebug = false;

            var theMenuRef = "parent.theMenu";
            var theMenu = eval(theMenuRef);
            var theBrowser = parent.theBrowser;
            var belowMenu = null;
            var menuStart = 0;

            if (parent.theBrowser) {
                if (parent.theBrowser.canOnError) {window.onerror = parent.defOnError;}
            }

            if (theMenu) {
                theMenu.amBusy = true;
                if (theBrowser.hasDHTML) {
                    if (document.layers) {
                        document.ids.menuTop.position = "absolute";
                        document.ids.menuBottom.position = "absolute";
                        document.ids.menuBottom.visibility = "hidden";
                        document.ids.statusMsgDiv.position = "absolute";
                    } else {
                        if (theBrowser.hasW3CDOM) {
                            try {
                                var styleSheetElement = document.styleSheets[0];
                                var styleSheetLength = styleSheetElement.cssRules.length;
                                styleSheetElement.insertRule("#menuTop { position:absolute } ", styleSheetLength++);
                                styleSheetElement.insertRule("#menuBottom { position:absolute } ", styleSheetLength++);
                                styleSheetElement.insertRule("#menuBottom { visibility:hidden } ", styleSheetLength++);
                                styleSheetElement.insertRule("#statusMsgDiv { position:absolute } ", styleSheetLength++);
                            }
                            catch (e) {
                                if (logIsDebug) { console.debug(e); }
                            }
                        }
                    }
                }
            }

            function myVoid() { ; }
            -->
        </script>
    </asp:PlaceHolder>

    <asp:PlaceHolder ID="Placeholder_AdminScript" runat="server">
        <script language="javascript" type="text/javascript">
            function logout() {
                setTimeout(function() {
                    <%# Page.ClientScript.GetPostBackEventReference(btLogout, "") %>;
                }, 0);
            }

            function postLogout() {
                try {
                   if(parent && parent.text) {
                      if(parent.text.document.getElementById("<%# ccPublisherWeb.CommonDefines.MODAL_PROGRESS_ID %>") != "undefined" && parent.text.document.getElementById("<%# ccPublisherWeb.CommonDefines.MODAL_PROGRESS_ID %>")) {
                         eval("parent.text.<%# ccPublisherWeb.CommonDefines.MODAL_PROGRESS_ID %>.Show()");
                      }
                   }
                } catch(e) { }

                if(parent) {
                   setTimeout(function() {
                      top.location = parent.location.href.replace(/&tree=Login/i, "").replace(/\?tree=Login&/i, "?").replace(/\?tree=Login/i, "");
                   }, 0);
                } else {
                   setTimeout(function() {
                      top.location = "<%# ResolveUrl("~") %>";
                   }, 0);
                }
            }
        </script>
    </asp:PlaceHolder>
</head>
<body>
    <form id="form1" runat="server">
        <div id="Menu">
            <%--
                If a customer menu template exists (templates/MenuTemplate.htm) the
                the template content is loaded here.
            --%>
            <asp:Literal ID="litMenuTemplateContent" runat="server" />
            <%--
                If no customer menu template exists (templates/MenuTemplate.htm)
                this default template is being used.
            --%>
            <asp:PlaceHolder ID="Placeholder_MenuContentDefault" runat="server">
                <div id="InnerMenu">
                    <div id="MenuMarginTop"></div>

                    <div id="menuTop">
                        <%-- Place anything you want to appear before the menu between these DIV tags. --%>

                        <asp:PlaceHolder ID="Placeholder_AdminMenu" runat="server">
                            <div id="AdminMenu">
                                <div class="Title"><%# TextDic.TxGet("Text_Ad_Statistiken")%></div>
                                    <ul>
                                        <li id="Admin_DownloadsByYearMonthDay" style="display: none">
                                            <a  href="<%# CommonFunc.AuthClassicAsp("admin/admin_year_month_day.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Downloads_YearMonthDay") %></a>
                                        </li>
                                        <li id="Admin_DownloadsByDay" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/statistik.asp?Mode=P_Down", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Downloads_nach_Datum") %></a>
                                        </li>
                                        <li id="Admin_ProductsByDownloads" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/statistik.asp?Mode=Prod_Down", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Produkte_nach_Downloads") %></a>
                                        </li>
                                        <li id="Admin_DownloadsByUser" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/statistik.asp?Mode=User", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Wer_hat_geladen") %></a>
                                        </li>
                                        <li id="Admin_CADFormats" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_cadformat.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_CAD_Formate") %></a>
                                        </li>
                                        <li id="Admin_DownloadsByLanguage" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_langlist.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_DownloadNachSprache") %></a>
                                        </li>
                                        <li id="Admin_StatisticsMailService" style="display: none">
                                            <a href="admin/StatisticsMailService.aspx" target="text"><%# TextDic.TxGet("Text_Ad_StatisticsEmailsService") %></a>
                                        </li>
                                        <li id="Admin_DownloadsByType" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_DownloadType.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_DownloadType") %></a>
                                        </li>
                                        <li id="Admin_DownloadsByClient" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_niederlassung_log.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Downloads_nach_Niederlassung")%></a>
                                        </li>
                                        <li id="Admin_UserLoginCount" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_userLoginCount.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Ad_Login_Historie")%></a>
                                        </li>
                                        <li id="Admin_DataPackages" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_DataPackages.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_LinkDataPackages")%></a>
                                        </li>
                                        <li id="Admin_RegisteredUsers" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_userlist.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_RegistrierteBenutzer") %></a>
                                        </li>
                                        <li id="Admin_Downloadcenter" style="display: none">
                                            <a href="<%# CommonFunc.AuthClassicAsp("admin/admin_center.asp", Session.SessionID) %>" target="text"><%# TextDic.TxGet("Text_Downloadcenter")%></a>
                                        </li>
                                    </ul>
                                    
                                    <a id="Admin_Logout" href="javascript:;" onclick="logout()" target="text"><%# ccPublisherWeb.TextDic.TxGet("Text_Logout") %></a>

                                    <div style="display: none">
                                        <asp:Button ID="btLogout" OnClick="Logout" runat="server" />
                                    </div>
                                </div>
                            </asp:PlaceHolder>
                        </div>
         
                        <script language="javascript" type="text/javascript">
                            <%-- "true" if a user is currently logged-in --%>
                            var isUserLogin = <%# ccPublisherWeb.CommonFunc.JsBool(ccPublisherWeb.Security.User.IsUserLogin) %>;                                      
                    
                            if(isUserLogin) {
                                var objAdminMenu = document.getElementById('AdminMenu');

                                if(objAdminMenu != undefined) { menuStart = objAdminMenu.offsetHeight; }
                            }

                            if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Menu starts on: ' + menuStart); }

                            if(theMenu) { parent.DrawMenu(theMenu); }
                            
                            var interval = false;
							var $window = $(window);
							var dimensions = [ $window.width(), $window.height() ];

                            $(window).resize(function() {
								if(!interval)
								{
									interval  = setInterval( function() {
										if( dimensions[ 0 ] === $window.width() && dimensions[ 1 ] ===  $window.height() )
										{
											clearInterval( interval );
											interval = false;

											if(theMenu) { theMenu.refresh(); }
										}
										else
										{
											 dimensions[ 0 ] = $window.width();
											 dimensions[ 1 ] = $window.height();
										}
									}, 100 );
								}
                            });
                            
                            //BEGIN - 2013-06-14 - CAL
                            //needed for correct alignment of menu items, if a tree node id is selected during load
                            $(document).ready(function () {
                                //we have to wait until all toggling is done
                                setTimeout(function() {
                                    if (theMenu) theMenu.refresh();
                                }, 3500);
                            });
                            //END - 2013-06-14 - CAL
                        </script>
         
                        <div id="menuBottom">
                            <%-- Place anything you want to appear after the menu between these DIV tags. --%>
                        </div>
                    </div>
                </asp:PlaceHolder>

                <script language="javascript" type="text/javascript">
                    function getDHTMLObj(objName) {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke getDHTMLObj: ' + objName); }

                        if (theBrowser.hasW3CDOM) {
                            return document.getElementById(objName).style;
                        } else {
                            return eval('document' + theBrowser.DHTMLRange + '.' + objName + theBrowser.DHTMLStyleObj);
                        }
                    }

                    function getDHTMLObjHeight(objName) {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke getDHTMLObjHeight: ' + objName); }

                        var result;
                        if (theBrowser.hasW3CDOM) {
                            result = document.getElementById(objName).offsetHeight;
                        } else {
                            result = eval('document' + theBrowser.DHTMLRange + '.' + objName + theBrowser.DHTMLDivHeight);
                        }

                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Result for getDHTMLObjHeight: ' + result); }

                        return result;
                    }

                    function setMenuHeight(theHeight) {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke setMenuHeight: ' + theHeight); }
                
                        getDHTMLObj('menuBottom').top = theHeight;
                    }

                    function drawLimitMarker() {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke drawLimitMarker'); }

                        var b = theBrowser;

                        if (theMenu && b.hasDHTML && b.needLM) {
                            var limitPos = theMenu.maxHeight + menuStart + getDHTMLObjHeight('menuBottom');

                            if (b.code == 'NS') {
                                if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Netscape-like browser detected.'); }
                                document.ids.limitMarker.position = "absolute";
                                document.ids.limitMarker.visibility = "hidden";
                                document.ids.limitMarker.top = limitPos;
                            }

                            if (b.code == 'MSIE') {
                                if (logIsDebug) { console.debug(logPrefix + logSeparator + 'IE-like browser detected.'); }

                                with (document.styleSheets["JoustStyles"]) {
                                    addRule("#limitMarker", "position:absolute");
                                    addRule("#limitMarker", "visibility:hidden");
                                    addRule("#limitMarker", "top:" + limitPos + "px");
                                }
                            }
                            document.writeln('<DIV ID="limitMarker">&nbsp;</DIV>');
                        }
                    }

                    function drawStatusMsg() {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke drawStatusMsg'); }

                        if (document.layers) {
                            document.ids.statusMsgDiv.top = menuStart;
                        }
                        document.writeln('<DIV ID="statusMsgDiv"><CENTER>Building Menu...</CENTER></DIV>');
                    }

                    function setTop() {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke setTop'); }
                
                        if (theMenu && theBrowser.hasDHTML) {
                            if (getDHTMLObj('menuTop')) {
                                drawStatusMsg();
                                menuStart = getDHTMLObjHeight("menuTop");
                            } else {
                                theBrowser.hasDHTML = false;
                            }
                        }
                    }

                    function setBottom() {
                        if (logIsDebug) { console.debug(logPrefix + logSeparator + 'Invoke setBottom'); }

                        if (theMenu) {
                            if (theBrowser.hasDHTML) {
                                var mb = getDHTMLObj('menuBottom');

                                if (mb) {
                                    drawLimitMarker();
                                    getDHTMLObj("statusMsgDiv").visibility = 'hidden';
                                    menuStart = getDHTMLObjHeight("menuTop");
                                    theMenu.refreshDHTML();

                                    if (theMenu.autoScrolling) { theMenu.scrollTo(theMenu.lastPMClicked); }

                                    mb.visibility = 'visible';
                                } else {
                                    theBrowser.hasDHTML = false;
                                    self.location.reload();
                                }
                            }
                            theMenu.amBusy = false;
                        }
                    }

                    setTop();
                    setBottom();

                    menuLoaded = true;
                </script>
            </div>
        </form>
    </body>
</html>