﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProgressThreadMonitor.aspx.cs" Inherits="ccPublisherWeb.ProgressThreadMonitor" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title></title>

   <style type="text/css">
      HTML, BODY,FORM
      {
         margin: 0;
         padding: 0;
         font-family: Arial;
         font-size: 11px;
      }
      
      #ThreadList 
      {
         width: 800px;
         border: solid 1px #000000;
         border-collapse: collapse;
      }
      
      #ThreadList THEAD TR
      {
         font-weight: bold;
      }
      
      #ThreadList THEAD TR TH
      {
         background-color: #CCCCCC;
         border-bottom: solid 1px #000000;
      }
      
      
      #ThreadList TR.ThreadRow
      {

      }
      
      #ThreadList TR.ThreadRow.Odd
      {
         background-color: #EEEEFF;
         border-top: solid 1px #DDDDDD;
      }
      
      #ThreadList TH, #ThreadList TD
      {
         font-family: Arial;
         font-size: 11px;
      }
      
      #ThreadList THREAD TH
      {
         font-weight: bold;
      }
      
      #ThreadList TD.Error
      {
         color: #FF0000 !important;
      }
      
      #ThreadList TD .ProgressBar
      {
         width: 150px;
         height: 12px;
         border: solid 1px #666666;
         position: relative;
      }
      
      #ThreadList TD .ProgressBar .Percentage
      {
         width: 0;
         height: 12px;
         position: absolute;
         top: 0;
         left: 0;
         background-color: #AAAAFF;
         z-index: 1;
      }
      
      #ThreadList TD .ProgressBar .Text
      {
         width: 100%;
         line-height: 12px;
         height: 12px;
         vertical-align: middle;
         position: absolute;
         top: 0;
         bottom: 0;
         left: 0;
         z-index: 2;
         font-size: 8px !important;
         text-align: center;
      }
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <table id="ThreadList" border="0" cellpadding="0" cellspacing="0">
         <thead>
            <tr>
               <th>Name</th>
               <th>GUID</th>
               <th>Started at</th>
               <th>&nbsp;</th>
               <th>Message</th>
               <th>Priority</th>
               <th>&nbsp;</th>
            </tr>
         </thead>
         <tbody>
            
         </tbody>
      </table>

      
      <script language="javascript" type="text/javascript">
         function updateThreadList() {
            var theadList = null;

            $.ajax({
               url: "<%# Request.Url.ToString() %>?GET_THREADS=1",
               cache: false,
               success: function(response) {
                  var continueOnError = true;

                  if(!String.IsNullOrEmpty(response)) {
                     try {
                        theadList = eval(response);
                     } catch(err) {
                        continueOnError = confirm("Error evaluation respsonse: " + err.description + "\nContinue?");
                     }
                  }

                  if(continueOnError) {
                     $("#ThreadList TBODY TR").remove();

                     if(theadList != null) {
                        for(var i=0; i<theadList.length; i++) {
                           var oddClass = (i % 2 == 0) ? "" : " Odd";
                           var disableStopButton = (theadList[i].abortrequested || theadList[i].hasfinished) ? " disabled=\"disabled\"" : "";
                           var message = theadList[i].haserror ? theadList[i].errormessage : theadList[i].progressmessage;
                           var messageCss = theadList[i].haserror ? " class=\"Error\"" : "";

                           var tRow =
                              "<tr class='ThreadRow" + oddClass + "' guid='" + theadList[i].guid + "'>" +
                              "<td>" + theadList[i].name +"</td>" +
                              "<td>" + theadList[i].guid + "</td>" +
                              "<td>" + theadList[i].datetimestarted + "</td>" +
                              "<td><div class='ProgressBar'><div class='Percentage' style='width:" + theadList[i].percent + "%'></div><div class='Text'>" + theadList[i].percent + "%</div></td>" +
                              "<td" + messageCss + ">" + message + "</td>" +
                              "<td>" + theadList[i].threadpriority + "</td>" +
                              "<td>" +
                              "   <input type=\"button\"" + disableStopButton + " value=\"Stop\" onclick=\"abortThread(this, '" + theadList[i].guid + "', false)\" />" +
                              "   <input type=\"button\" value=\"Remove\" onclick=\"abortThread(this, '" + theadList[i].guid + "', true)\" />" +
                              "</td>" +
                              "</tr>";

                           $("#ThreadList TBODY").append(tRow);
                        }
                     }

                     setTimeout(updateThreadList, 2000);
                  }
               }
            });
         }


         function abortThread(sender, guid, remove) {
            var abortURL = null;

            if(remove) {
               abortURL= "BackgroundThreadStatusHandler.ashx?GUID=" + guid + "&MODE=<%# ccPublisherWeb.BackgroundThreadCallbackModes.AbortAndRemove.ToString() %>";
            } else {
               abortURL= "BackgroundThreadStatusHandler.ashx?GUID=" + guid + "&MODE=<%# ccPublisherWeb.BackgroundThreadCallbackModes.Abort.ToString() %>";
            }
      
            $(sender).attr("disabled", "disabled");

            $.ajax({
               url: abortURL,
               cache: false,
               success: function(response) { }
            });
         }


         $(function() {
            updateThreadList();
         });
      </script>
   </form>
</body>
</html>
